/*
 The Techlabs Pure MVC Tutorial
 Copyright (c) 2009 Pedro Furtado (pedro.furtado@gmail.com)
 Your reuse is governed by the Creative Commons Attribution 3.0 License
*/
package com.techlabs.puremvc.controller
{
    import com.techlabs.puremvc.ApplicationFacade;
    import com.techlabs.puremvc.view.ApplicationMediator;
    

    import org.puremvc.as3.interfaces.*;
    import org.puremvc.as3.patterns.command.*;
    import org.puremvc.as3.patterns.observer.*;
    
    /**
     * Here we'll initialize the application mediator that will in hand initialize
     * the rest of the mediators.
     */
    public class ViewPrepCommand extends SimpleCommand
    {
        override public function execute( note:INotification ) :void    
		{
            // Register the ApplicationMediator
            facade.registerMediator( new ApplicationMediator( note.getBody() as TheTechLabsRssReader ) );
			
			
        }
    }
}
